#ifndef __C4DBASESEQUENCE_H
#define __C4DBASESEQUENCE_H

#include "c4d_baselist.h"
#include "operatingsystem.h"
#include "ge_vector.h"

class BaseObject;
class BaseDocument;
class BaseTrack;
class BaseKey;

class BaseSequence : public BaseList2D
{
	private:
		BaseSequence(void);
	public:
		BaseTrack			*GetTrack(void) { return (BaseTrack*)AtCall(GetMain)(); }
		BaseList2D    *GetObject  (void);

		void					SetT1(const BaseTime &time);
		BaseTime			GetT1(void);
		void					SetT2(const BaseTime &time);
		BaseTime			GetT2(void);
		void					SetT3(const BaseTime &time);
		BaseTime			GetT3(void);
		void					SetSoft(Bool b);
		Bool					GetSoft(void);
		void					SetLeftInfluence(Bool b);
		Bool					GetLeftInfluence(void);
		void					SetRightInfluence(Bool b);
		Bool					GetRightInfluence(void);

		void					FlushAllKeys(void);
		LONG					GetKeyCount(void);
		BaseKey				*FindKey(const BaseTime &time);
		BaseTime			GetLeft(void);
		BaseTime			GetRight(void);
		BaseKey				*GetFirstKey(void);
		Bool					InsertKey(BaseKey *bk);

		BaseSequence *GetNext(void) { return (BaseSequence*)AtCall(GetNext)(); }
		BaseSequence *GetPred(void) { return (BaseSequence*)AtCall(GetPred)(); }

		static BaseSequence *Alloc(LONG type);
		static void Free(BaseSequence *&bl);
};

class PluginSequence : public BaseSequence
{
	public:
		static PluginSequence *Alloc(LONG type);
		static void Free(PluginSequence *&key);
};

class SoundSequence : public BaseSequence
{
	private:
		SoundSequence(void);
	public:
		BaseSound *GetSound(void);
		void SetSound(BaseSound *bs);

		static SoundSequence *Alloc();
		static void Free(SoundSequence *&bl);
};

#endif
